/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferUtil {
    public static Transaction getTransaction() {
        TransactionContext open;
        if (Transaction.isOpen() && (open = Transaction.getCurrentUnsafe()) != null) {
            return open.openNested();
        }
        return Transaction.openOuter();
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_1937 level, class_2338 pos, @Nullable class_2350 side) {
        return TransferUtil.getItemStorage(level, pos, null, side);
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_1937 level, class_2338 pos) {
        return TransferUtil.getItemStorage(level, pos, null);
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_2586 be, @Nullable class_2350 side) {
        return TransferUtil.getItemStorage(null, null, be, side);
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_2586 be) {
        return TransferUtil.getItemStorage(be, null);
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_1937 level, class_2338 pos, class_2586 be, @Nullable class_2350 side) {
        if (be == null) {
            Objects.requireNonNull(level, "If a null Block Entity is provided, the Level may NOT be null!");
            Objects.requireNonNull(pos, "If a null Block Entity is provided, the pos may NOT be null!");
            be = level.method_8321(pos);
        }
        if (level == null || pos == null) {
            Objects.requireNonNull(be, "If a null level or pos is provided, the Block Entity may NOT be null!");
            level = be.method_10997();
            pos = be.method_11016();
        }
        if (level == null) {
            return null;
        }
        class_2680 state = be == null ? level.method_8320(pos) : be.method_11010();
        return (Storage)ItemStorage.SIDED.find(level, pos, state, be, (Object)side);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_1937 level, class_2338 pos, @Nullable class_2350 side) {
        return TransferUtil.getFluidStorage(level, pos, null, side);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_1937 level, class_2338 pos) {
        return TransferUtil.getFluidStorage(level, pos, null);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_2586 be, @Nullable class_2350 side) {
        return TransferUtil.getFluidStorage(null, null, be, side);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_2586 be) {
        return TransferUtil.getFluidStorage(be, null);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_1937 level, class_2338 pos, class_2586 be, @Nullable class_2350 side) {
        if (be == null) {
            Objects.requireNonNull(level, "If a null Block Entity is provided, the Level may NOT be null!");
            Objects.requireNonNull(pos, "If a null Block Entity is provided, the pos may NOT be null!");
            be = level.method_8321(pos);
        }
        if (level == null || pos == null) {
            Objects.requireNonNull(be, "If a null level or pos is provided, the Block Entity may NOT be null!");
            level = be.method_10997();
            pos = be.method_11016();
        }
        if (level == null) {
            return null;
        }
        class_2680 state = be == null ? level.method_8320(pos) : be.method_11010();
        return (Storage)FluidStorage.SIDED.find(level, pos, state, be, (Object)side);
    }

    @Nullable
    public static <T> Storage<T> getStorage(class_2586 be, @Nullable class_2350 side, Class<T> capability) {
        if (capability == ItemVariant.class) {
            return TransferUtil.getItemStorage(null, null, be, side);
        }
        if (capability == FluidVariant.class) {
            return TransferUtil.getFluidStorage(null, null, be, side);
        }
        throw new RuntimeException("Class must either be ItemVariant or FluidVariant!");
    }

    public static Optional<FluidStack> getFluidContained(class_1799 container) {
        FluidStack first;
        Storage storage;
        if (container != null && !container.method_7960() && (storage = (Storage)ContainerItemContext.withInitial((class_1799)container).find(FluidStorage.ITEM)) != null && (first = TransferUtil.getFirstFluid((Storage<FluidVariant>)storage)) != null) {
            return Optional.of(first);
        }
        return Optional.empty();
    }

    public static <T> long firstCapacity(Storage<T> storage) {
        List<Long> capacities = TransferUtil.capacities(storage, 1);
        return capacities.size() > 0 ? capacities.get(0) : 0L;
    }

    public static <T> long totalCapacity(Storage<T> storage) {
        long total = 0L;
        List<Long> capacities = TransferUtil.capacities(storage, Integer.MAX_VALUE);
        for (Long l : capacities) {
            total += l.longValue();
        }
        return total;
    }

    public static <T> List<Long> capacities(Storage<T> storage, int cutoff) {
        ArrayList<Long> capacities = new ArrayList<Long>();
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : storage) {
                capacities.add(view.getCapacity());
                if (capacities.size() != cutoff) continue;
                break;
            }
        }
        return capacities;
    }

    public static FluidStack firstCopyOrEmpty(Storage<FluidVariant> storage) {
        return TransferUtil.firstOrEmpty(storage).copy();
    }

    public static FluidStack firstOrEmpty(Storage<FluidVariant> storage) {
        FluidStack stack = TransferUtil.getFirstFluid(storage);
        return stack == null ? FluidStack.EMPTY : stack;
    }

    @Nullable
    public static FluidStack getFirstFluid(Storage<FluidVariant> storage) {
        List<FluidStack> stacks = TransferUtil.getFluids(storage, 1);
        if (stacks.size() > 0) {
            return stacks.get(0);
        }
        return null;
    }

    public static List<FluidStack> getAllFluids(Storage<FluidVariant> storage) {
        return TransferUtil.getFluids(storage, Integer.MAX_VALUE);
    }

    public static List<FluidStack> getFluids(Storage<FluidVariant> storage, int cutoff) {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : storage.nonEmptyViews()) {
                stacks.add(new FluidStack(view));
                if (stacks.size() != cutoff) continue;
                break;
            }
        }
        return stacks;
    }

    public static List<class_1799> getAllItems(Storage<ItemVariant> storage) {
        return TransferUtil.getItems(storage, Integer.MAX_VALUE);
    }

    public static List<class_1799> getItems(Storage<ItemVariant> storage, int cutoff) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : storage.nonEmptyViews()) {
                int stackSize;
                ItemVariant item = (ItemVariant)view.getResource();
                int maxSize = item.getItem().method_7882();
                for (long contained = view.getAmount(); contained > 0L && stacks.size() < cutoff; contained -= (long)stackSize) {
                    stackSize = Math.min(maxSize, (int)contained);
                    stacks.add(item.toStack(stackSize));
                }
                if (stacks.size() != cutoff) continue;
                break;
            }
        }
        return stacks;
    }

    public static <T> boolean clearStorage(Storage<T> storage) {
        if (!storage.supportsExtraction()) {
            return false;
        }
        boolean success = true;
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : storage.nonEmptyViews()) {
                long amount = view.getAmount();
                long extracted = view.extract(view.getResource(), amount, (TransactionContext)t);
                if (extracted >= amount) continue;
                success = false;
            }
            t.commit();
        }
        return success;
    }

    public static FluidStack extractAnyFluid(Storage<FluidVariant> storage, long maxAmount, Transaction tx) {
        if (!storage.supportsExtraction()) {
            return FluidStack.EMPTY;
        }
        ResourceAmount extracted = StorageUtil.extractAny(storage, (long)maxAmount, (TransactionContext)tx);
        return extracted == null ? FluidStack.EMPTY : new FluidStack(extracted);
    }

    public static FluidStack extractAnyFluid(Storage<FluidVariant> storage, long maxAmount) {
        try (Transaction tx = TransferUtil.getTransaction();){
            FluidStack fluid = TransferUtil.extractAnyFluid(storage, maxAmount, tx);
            tx.commit();
            FluidStack fluidStack = fluid;
            return fluidStack;
        }
    }

    public static FluidStack simulateExtractAnyFluid(Storage<FluidVariant> storage, long maxAmount) {
        try (Transaction t = TransferUtil.getTransaction();){
            FluidStack fluidStack = TransferUtil.extractAnyFluid(storage, maxAmount, t);
            return fluidStack;
        }
    }

    public static class_1799 extractAnyItem(Storage<ItemVariant> storage, long maxAmount, Transaction tx) {
        if (!storage.supportsExtraction()) {
            return class_1799.field_8037;
        }
        int max = (int)Math.min(Integer.MAX_VALUE, maxAmount);
        ResourceAmount extracted = StorageUtil.extractAny(storage, (long)max, (TransactionContext)tx);
        return extracted == null ? class_1799.field_8037 : ((ItemVariant)extracted.resource()).toStack((int)extracted.amount());
    }

    public static class_1799 extractAnyItem(Storage<ItemVariant> storage, long maxAmount) {
        try (Transaction tx = TransferUtil.getTransaction();){
            class_1799 stack = TransferUtil.extractAnyItem(storage, maxAmount, tx);
            tx.commit();
            class_1799 class_17992 = stack;
            return class_17992;
        }
    }

    public static class_1799 simulateExtractAnyItem(Storage<ItemVariant> storage, long maxAmount) {
        try (Transaction tx = TransferUtil.getTransaction();){
            class_1799 class_17992 = TransferUtil.extractAnyItem(storage, maxAmount, tx);
            return class_17992;
        }
    }

    public static <T> long simulateExtractView(@NotNull StorageView<T> view, T variant, long amount) {
        try (Transaction t = TransferUtil.getTransaction();){
            long l = view.extract(variant, amount, (TransactionContext)t);
            return l;
        }
    }

    public static <T> long extract(Storage<T> storage, T variant, long amount) {
        if (!storage.supportsExtraction()) {
            return 0L;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            long extracted = storage.extract(variant, amount, (TransactionContext)t);
            t.commit();
            long l = extracted;
            return l;
        }
    }

    public static long extractItem(Storage<ItemVariant> storage, class_1799 stack) {
        return TransferUtil.extract(storage, ItemVariant.of((class_1799)stack), stack.method_7947());
    }

    public static long extractFluid(Storage<FluidVariant> storage, FluidStack stack) {
        return TransferUtil.extract(storage, stack.getType(), stack.getAmount());
    }

    public static <T> long insert(Storage<T> storage, T variant, long amount) {
        if (!storage.supportsInsertion()) {
            return 0L;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            long inserted = storage.insert(variant, amount, (TransactionContext)t);
            t.commit();
            long l = inserted;
            return l;
        }
    }

    public static long insertItem(Storage<ItemVariant> storage, class_1799 stack) {
        return TransferUtil.insert(storage, ItemVariant.of((class_1799)stack), stack.method_7947());
    }

    public static long insertFluid(Storage<FluidVariant> storage, FluidStack stack) {
        return TransferUtil.insert(storage, stack.getType(), stack.getAmount());
    }

    public static long insertToMainInv(class_1657 player, ItemVariant variant, long amount) {
        long inserted = 0L;
        try (Transaction t = TransferUtil.getTransaction();){
            PlayerInventoryStorage inv = PlayerInventoryStorage.of((class_1657)player);
            if (!inv.supportsInsertion()) {
                long l = 0L;
                return l;
            }
            List slots = inv.getSlots();
            for (int i = 9; i < 36; ++i) {
                SingleSlotStorage slot = (SingleSlotStorage)slots.get(i);
                inserted += slot.insert((Object)variant, amount - inserted, (TransactionContext)t);
                if (amount == 0L) break;
            }
            t.commit();
            long l = inserted;
            return l;
        }
    }

    public static List<class_1799> extractAllAsStacks(Storage<ItemVariant> storage) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        if (!storage.supportsExtraction()) {
            return stacks;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            StorageView currentView;
            Iterator itr = storage.nonEmptyIterator();
            StorageView storageView = currentView = itr.hasNext() ? (StorageView)itr.next() : null;
            while (currentView != null) {
                int max;
                long contained = currentView.getAmount();
                if (contained == 0L) {
                    currentView = itr.hasNext() ? (StorageView)itr.next() : null;
                    continue;
                }
                ItemVariant variant = (ItemVariant)currentView.getResource();
                long extracted = currentView.extract((Object)variant, (long)(max = (int)Math.min(contained, (long)variant.getItem().method_7882())), (TransactionContext)t);
                if (extracted == 0L) {
                    currentView = itr.hasNext() ? (StorageView)itr.next() : null;
                    continue;
                }
                class_1799 stack = variant.toStack((int)extracted);
                stacks.add(stack);
            }
            t.commit();
            ArrayList<class_1799> arrayList = stacks;
            return arrayList;
        }
    }

    public static class_1799 getFilledBucket(FluidVariant variant) {
        ContainerItemContext context = ContainerItemContext.withInitial((class_1799)class_1802.field_8550.method_7854());
        try (Transaction tx = TransferUtil.getTransaction();){
            Storage storage = (Storage)context.find(FluidStorage.ITEM);
            if (storage != null) {
                storage.insert((Object)variant, 81000L, (TransactionContext)tx);
                tx.commit();
            }
        }
        return context.getItemVariant().toStack();
    }

    @Nullable
    public static <T extends TransferVariant<?>> ResourceAmount<T> extractMatching(Storage<T> storage, Predicate<T> predicate, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        if (storage == null) {
            return null;
        }
        try {
            for (StorageView view : storage.nonEmptyViews()) {
                long amount;
                TransferVariant resource = (TransferVariant)view.getResource();
                if (!predicate.test(resource) || (amount = view.extract((Object)resource, maxAmount, transaction)) <= 0L) continue;
                return new ResourceAmount((Object)resource, amount);
            }
        }
        catch (Exception e) {
            class_128 report = class_128.method_560((Throwable)e, (String)"Extracting resources from storage");
            report.method_562("Extraction details").method_577("Storage", storage::toString).method_578("Max amount", (Object)maxAmount).method_578("Transaction", (Object)transaction);
            throw new class_148(report);
        }
        return null;
    }

    public static int truncateLong(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }
}

